
### Dynamic Entity Modeling

- Core method for detecting anomalous and risky behavior in networks
- Involves dynamic behavior analysis, comparing observed behaviors to known threats and artifacts
- Detects both known and unknown threats

#### Telemetry Collection and Role Assignment

- Collects various forms of telemetry for each endpoint
- Automatically assigns or predicts device roles (e.g., DNS server, Android endpoint, mail server)
- Roles provide high-level behavioral expectations for devices

#### Device Group Classification and Consistency

- Groups devices by classification to compare consistency with similar devices
- Uses algorithms to detect critical deviations from past behavior

#### Rule Analysis and Forecasting

- Rule analysis checks for violations of established network rules (protocol, port, blocked lists)
- Forecasting predicts device behavior based on historical activity and checks current behavior against these predictions

---

### Observations, Alerts, and Events

#### Observations

- Fundamental unit of event information
- Journaled facts about network traffic (e.g., new connections, repeated heartbeats, high throughput)
- Not always an alarm, but significant for analysis

#### Alerts

- Triggered by either a single significant observation or multiple supporting observations
- Example:
    - Single observation: Geographically Unusual Remote Access
    - Multiple observations: Geographically Unusual AWS API Usage

#### Reducing Alert Clutter

- Related observations are aggregated into single alerts to minimize information overload
- Helps analysts focus on actionable threats

---

### Examples of Anomalies Detected

- High data transfers to external destinations inconsistent with baseline
- Bad protocol observations (e.g., HTTP session over TCP port 179)
- Internal port scanning activity

---

### Alert Management

- Once an alert is acknowledged and closed, the same observation will not trigger the same alert again
- Secure Cloud Analytics baselines networks for up to 35 days to avoid excessive benign alerts after initial installation

---

### Integration and Automation

#### OpenAPI Platform

- Allows integration with third-party tools and applications

#### Services and Webhooks

- Can send feeds to:
    - Email
    - Helpdesk ticketing systems
    - ChatOps tools (e.g., Slack, Cisco Webex Teams, Amazon SNS)